/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import { Plugin } from '@form-validation/core';

export interface TriggerOptions {
    delay?:
        | number
        | {
              [field: string]: number;
          };
    event:
        | string
        | {
              [field: string]: boolean | string;
          };
    // Only perform the validation if the field value exceed this number of characters
    threshold?:
        | number
        | {
              [field: string]: number;
          };
}

export interface EventHandler {
    element: HTMLElement;
    event: string;
    field: string;
    handler: EventListener;
}
export interface TriggerExecutedEvent {
    element: HTMLElement;
    event: Event;
    field: string;
}

export class Trigger extends Plugin<TriggerOptions> {
    constructor(opts?: TriggerOptions);
}
