/**
 * FormValidation (https://formvalidation.io)
 * The best validation library for JavaScript
 * (c) 2013 - 2023 Nguyen Huu Phuoc <me@phuoc.ng>
 */

import {
    type Localization,
    type ValidateFunctionInterface,
    type ValidateOptions,
    type ValidateResult,
} from '@form-validation/core';

export interface GreaterThanOptions extends ValidateOptions {
    // Default is true
    inclusive: boolean;
    message: string;
    min?: number;
}
export interface GreaterThanLocalization extends Localization {
    greaterThan: {
        default: string;
        notInclusive: string;
    };
}

export function greaterThan(): ValidateFunctionInterface<GreaterThanOptions, ValidateResult>;
