# Search Insights

[![Build Status](https://circleci.com/gh/algolia/search-insights.js.svg?style=shield)](https://github.com/algolia/search-insights.js)
[![npm version](https://badge.fury.io/js/search-insights.svg)](https://badge.fury.io/js/search-insights)

Search Insights lets you report click, conversion and view metrics using the [Algolia Insights API](https://www.algolia.com/doc/rest-api/insights/#overview).

## Table of Contents

<!-- toc -->

- [Notices](#notices)
  - [Cookie usage](#cookie-usage)
  - [Payload validation](#payload-validation)
- [Getting started](#getting-started)
  - [Browser](#browser)
  - [Node.js](#nodejs)
- [Documentation](#documentation)
- [Contributing](#contributing)
  - [Releasing](#releasing)
- [License](#license)

<!-- tocstop -->

> **NOTE:** You're looking at the documentation of `search-insights` v2. (_Click [here](https://github.com/algolia/search-insights.js/blob/v1/README.md) for v1.x documentation._)

## Notices

### Cookie usage

v2 introduces a breaking change which is `useCookie` being `false` by default.

### Payload validation

Since v2.0.4, search-insights no longer validates event payloads.
You can visit https://algolia.com/events/debugger instead.

---

## Getting started

> We have created dedicated integrations for Google Tag Manager and Segment. If you are using either of these platforms,
> it is recommended to use the dedicated integrations to manage sending events to the [Insights API][insights-api].
>
> - [Google Tag Manager](https://www.algolia.com/doc/guides/sending-events/connectors/google-tag-manager/)
> - [Segment](https://www.algolia.com/doc/guides/sending-events/connectors/segment/)

### Browser

For information on how to set up `search-insights.js` in a browser environment, see our documentation on [Installing and Initializing the Insights Client][insights-js-docs].

We also have documentation for using `search-insights.js` with [InstantSearch][instantsearch] and [Autocomplete][autocomplete].

- For information on using `search-insights.js` with [InstantSearch][instantsearch], see our documentation on [Sending click and conversion events with InstantSearch.js][instantsearch-guide].
- For information on using `search-insights.js` with [Autocomplete][autocomplete], see our documentation on [Sending Algolia Insights events with Autocomplete][autocomplete-guide].

> **NOTE:** If you are using [Require.js](https://requirejs.org/), see our [Note for Require.js users](./docs/requirejs.md).

### Node.js

For information on how to set up `search-insights.js` in a Node.js environment, see our guide on [Installing and Initializing the Insights Client for Node.js](./docs/nodejs.md).

[insights-api]: https://www.algolia.com/doc/rest-api/insights/
[insights-js-docs]: https://www.algolia.com/doc/api-client/methods/insights/#install-the-insights-client
[instantsearch]: https://www.algolia.com/doc/guides/building-search-ui/what-is-instantsearch/js/
[instantsearch-guide]: https://www.algolia.com/doc/guides/building-search-ui/events/js/
[autocomplete]: https://www.algolia.com/doc/ui-libraries/autocomplete/introduction/what-is-autocomplete/
[autocomplete-guide]: https://www.algolia.com/doc/ui-libraries/autocomplete/guides/sending-algolia-insights-events/

## Documentation

Documentation for `search-insights.js` can be found in our main [Algolia Docs](https://algolia.com/docs) website.
For API Client reference information, see the [Insights API Client Documentation](https://www.algolia.com/doc/api-client/methods/insights/).

## Contributing

To run the examples and the code, you need to run two separate commands:

- `yarn dev` runs webpack and the Node.js server
- `yarn build:dev` runs Rollup in watch mode

### Releasing

For information on releasing, see [RELEASE.md](./RELEASE.md).

## License

Search Insights is [MIT licensed](LICENSE.md).
