<?php $__env->startSection('title', 'Kanban - Apps'); ?>

<?php $__env->startSection('vendor-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/jkanban/jkanban.scss', 'resources/assets/vendor/libs/select2/select2.scss',
'resources/assets/vendor/libs/flatpickr/flatpickr.scss', 'resources/assets/vendor/libs/quill/typography.scss',
'resources/assets/vendor/libs/quill/katex.scss', 'resources/assets/vendor/libs/quill/editor.scss']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-style'); ?>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/vendor/scss/pages/app-kanban.scss'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('vendor-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')(['resources/assets/vendor/libs/moment/moment.js', 'resources/assets/vendor/libs/flatpickr/flatpickr.js',
'resources/assets/vendor/libs/select2/select2.js', 'resources/assets/vendor/libs/jkanban/jkanban.js',
'resources/assets/vendor/libs/quill/katex.js', 'resources/assets/vendor/libs/quill/quill.js']); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('page-script'); ?>
<?php echo app('Illuminate\Foundation\Vite')('resources/assets/js/app-kanban.js'); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('content'); ?>
<div class="app-kanban">

  <!-- Add new board -->
  <div class="row">
    <div class="col-12">
      <form class="kanban-add-new-board">
        <label class="kanban-add-board-btn" for="kanban-add-board-input">
          <i class="icon-base ti tabler-plus"></i>
          <span class="align-middle">Add new</span>
        </label>
        <input type="text" class="form-control w-px-250 kanban-add-board-input mb-4 d-none"
          placeholder="Add Board Title" id="kanban-add-board-input" required />
        <div class="mb-4 kanban-add-board-input d-none">
          <button class="btn btn-primary btn-sm me-4">Add</button>
          <button type="button" class="btn btn-label-secondary btn-sm kanban-add-board-cancel-btn">Cancel</button>
        </div>
      </form>
    </div>
  </div>

  <!-- Kanban Wrapper -->
  <div class="kanban-wrapper"></div>

  <!-- Edit Task/Task & Activities -->
  <div class="offcanvas offcanvas-end kanban-update-item-sidebar">
    <div class="offcanvas-header border-bottom">
      <h5 class="offcanvas-title">Edit Task</h5>
      <button type="button" class="btn-close" data-bs-dismiss="offcanvas" aria-label="Close"></button>
    </div>
    <div class="offcanvas-body pt-0">
      <div class="nav-align-top">
        <ul class="nav nav-tabs mb-5 rounded-0">
          <li class="nav-item">
            <button class="nav-link active" data-bs-toggle="tab" data-bs-target="#tab-update">
              <i class="icon-base ti tabler-edit icon-18px me-1_5"></i>
              <span class="align-middle">Edit</span>
            </button>
          </li>
          <li class="nav-item">
            <button class="nav-link" data-bs-toggle="tab" data-bs-target="#tab-activity">
              <i class="icon-base ti tabler-chart-pie-2 icon-18px me-1_5"></i>
              <span class="align-middle">Activity</span>
            </button>
          </li>
        </ul>
      </div>
      <div class="tab-content p-0">
        <!-- Update item/tasks -->
        <div class="tab-pane fade show active" id="tab-update" role="tabpanel">
          <form>
            <div class="mb-5">
              <label class="form-label" for="title">Title</label>
              <input type="text" id="title" class="form-control" placeholder="Enter Title" />
            </div>
            <div class="mb-5">
              <label class="form-label" for="due-date">Due Date</label>
              <input type="text" id="due-date" class="form-control" placeholder="Enter Due Date" />
            </div>
            <div class="mb-5">
              <label class="form-label" for="label"> Label</label>
              <select class="select2 select2-label form-select" id="label">
                <option data-color="bg-label-success" value="UX">UX</option>
                <option data-color="bg-label-warning" value="Images">Images</option>
                <option data-color="bg-label-info" value="Info">Info</option>
                <option data-color="bg-label-danger" value="Code Review">Code Review</option>
                <option data-color="bg-label-secondary" value="App">App</option>
                <option data-color="bg-label-primary" value="Charts & Maps">Charts & Maps</option>
              </select>
            </div>
            <div class="mb-5">
              <label class="form-label">Assigned</label>
              <div class="assigned d-flex flex-wrap"></div>
            </div>
            <div class="mb-5">
              <label class="form-label" for="attachments">Attachments</label>
              <div>
                <input type="file" class="form-control" id="attachments" />
              </div>
            </div>
            <div class="mb-5">
              <label class="form-label">Comment</label>
              <div class="comment-editor border-bottom-0"></div>
              <div class="d-flex justify-content-end">
                <div class="comment-toolbar">
                  <span class="ql-formats me-0">
                    <button class="ql-bold"></button>
                    <button class="ql-italic"></button>
                    <button class="ql-underline"></button>
                    <button class="ql-link"></button>
                    <button class="ql-image"></button>
                  </span>
                </div>
              </div>
            </div>
            <div>
              <div class="d-flex flex-wrap">
                <button type="button" class="btn btn-primary me-4" data-bs-dismiss="offcanvas">Update</button>
                <button type="button" class="btn btn-label-danger" data-bs-dismiss="offcanvas">Delete</button>
              </div>
            </div>
          </form>
        </div>
        <!-- Activities -->
        <div class="tab-pane fade text-heading" id="tab-activity" role="tabpanel">
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-success rounded-circle">HJ</span>
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Jordan</span> Left the board.</p>
              <small class="text-body-secondary">Today 11:00 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/6.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Dianna</span> mentioned <span class="text-primary">@bruce</span> in a comment.</p>
              <small class="text-body-secondary">Today 10:20 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/2.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Martian</span> added moved Charts & Maps task to the done board.</p>
              <small class="text-body-secondary">Today 10:00 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/1.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Barry</span> Commented on App review task.</p>
              <small class="text-body-secondary">Today 8:32 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-dark rounded-circle">BW</span>
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Bruce</span> was assigned task of code review.</p>
              <small class="text-body-secondary">Today 8:30 PM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-danger rounded-circle">CK</span>
            </div>
            <div class="media-body">
              <p class="mb-0">
                <span>Clark</span> assigned task UX Research to
                <span class="text-primary">@martian</span>
              </p>
              <small class="text-body-secondary">Today 8:00 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/4.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Ray</span> Added moved <span>Forms & Tables</span> task from in progress to done.
              </p>
              <small class="text-body-secondary">Today 7:45 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/1.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Barry</span> Complete all the tasks assigned to him.</p>
              <small class="text-body-secondary">Today 7:17 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-success rounded-circle">HJ</span>
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Jordan</span> added task to update new images.</p>
              <small class="text-body-secondary">Today 7:00 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <img src="<?php echo e(asset('assets/img/avatars/6.png')); ?>" alt="Avatar" class="rounded-circle" />
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Dianna</span> moved task <span>FAQ UX</span> from in progress to done board.</p>
              <small class="text-body-secondary">Today 7:00 AM</small>
            </div>
          </div>
          <div class="media mb-4 d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-danger rounded-circle">CK</span>
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Clark</span> added new board with name <span>Done</span>.</p>
              <small class="text-body-secondary">Yesterday 3:00 PM</small>
            </div>
          </div>
          <div class="media d-flex align-items-center">
            <div class="avatar me-3 flex-shrink-0">
              <span class="avatar-initial bg-label-dark rounded-circle">BW</span>
            </div>
            <div class="media-body">
              <p class="mb-0"><span>Bruce</span> added new task in progress board.</p>
              <small class="text-body-secondary">Yesterday 12:00 PM</small>
            </div>
          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home1/dev61at/vuexytemp.dev61at.securebrandtech.com/resources/views/content/apps/app-kanban.blade.php ENDPATH**/ ?>