<?php
$configData = Helper::appClasses();
?>



<?php $__env->startSection('title', 'Account settings - Pages'); ?>

<?php $__env->startSection('content'); ?>
<div class="row">
  <div class="col-md-12">
    <div class="nav-align-top">
      <ul class="nav nav-pills flex-column flex-md-row mb-6 gap-md-0 gap-2">
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('pages/account-settings-account')); ?>"><i class="icon-base ti tabler-users icon-sm me-1_5"></i> Account</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('pages/account-settings-security')); ?>"><i class="icon-base ti tabler-lock icon-sm me-1_5"></i> Security</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('pages/account-settings-billing')); ?>"><i class="icon-base ti tabler-bookmark icon-sm me-1_5"></i> Billing & Plans</a>
        </li>
        <li class="nav-item">
          <a class="nav-link" href="<?php echo e(url('pages/account-settings-notifications')); ?>"><i class="icon-base ti tabler-bell icon-sm me-1_5"></i> Notifications</a>
        </li>
        <li class="nav-item">
          <a class="nav-link active" href="javascript:void(0);"><i class="icon-base ti tabler-link icon-sm me-1_5"></i> Connections</a>
        </li>
      </ul>
    </div>
    <div class="card">
      <div class="row">
        <div class="col-md-6 col-12">
          <div class="card-header">
            <h5 class="mb-0">Connected Accounts</h5>
            <p class="my-0 card-subtitle">Display content from your connected accounts on your site</p>
          </div>
          <div class="card-body">
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/google.png')); ?>" alt="google" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                <div class="mb-sm-0 mb-2">
                  <h6 class="mb-0">Google</h6>
                  <small>Calendar and contacts</small>
                </div>
                <div class="text-end">
                  <div class="form-check form-switch mb-0">
                    <input type="checkbox" class="form-check-input" checked />
                  </div>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/slack.png')); ?>" alt="slack" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                <div class="mb-sm-0 mb-2">
                  <h6 class="mb-0">Slack</h6>
                  <small>Communication</small>
                </div>
                <div class="text-end">
                  <div class="form-check form-switch mb-0">
                    <input type="checkbox" class="form-check-input" />
                  </div>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/github.png')); ?>" alt="github" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                <div class="mb-sm-0 mb-2">
                  <h6 class="mb-0">Github</h6>
                  <small>Manage your Git repositories</small>
                </div>
                <div class="text-end">
                  <div class="form-check form-switch mb-0">
                    <input type="checkbox" class="form-check-input" checked />
                  </div>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/mailchimp.png')); ?>" alt="mailchimp" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                <div class="mb-sm-0 mb-2">
                  <h6 class="mb-0">Mailchimp</h6>
                  <small>Email marketing service</small>
                </div>
                <div class="text-end">
                  <div class="form-check form-switch mb-0">
                    <input type="checkbox" class="form-check-input" checked />
                  </div>
                </div>
              </div>
            </div>
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/asana.png')); ?>" alt="asana" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 d-flex align-items-center justify-content-between">
                <div class="mb-sm-0 mb-2">
                  <h6 class="mb-0">Asana</h6>
                  <small>Communication</small>
                </div>
                <div class="text-end">
                  <div class="form-check form-switch mb-0">
                    <input type="checkbox" class="form-check-input" />
                  </div>
                </div>
              </div>
            </div>
            <!-- /Connections -->
          </div>
        </div>
        <div class="col-md-6 col-12">
          <div class="card-header">
            <h5 class="mb-0">Social Accounts</h5>
            <p class="my-0 card-subtitle">Display content from social accounts on your site</p>
          </div>
          <div class="card-body">
            <!-- Social Accounts -->
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/facebook.png')); ?>" alt="facebook" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 row">
                <div class="col-7">
                  <h6 class="mb-0">Facebook</h6>
                  <small>Not Connected</small>
                </div>
                <div class="col-5 text-end mt-sm-0 mt-2">
                  <button class="btn btn-icon btn-label-secondary"><i class="icon-base icon-22px ti tabler-link"></i></button>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/twitter-' . $configData['theme'] . '.png')); ?>" alt="twitter" class="me-4" height="32" data-app-dark-img="icons/brands/twitter-dark.png" data-app-light-img="icons/brands/twitter-light.png" />
              </div>
              <div class="flex-grow-1 row">
                <div class="col-7">
                  <h6 class="mb-0">Twitter</h6>
                  <a href="<?php echo e(config('variables.twitterUrl')); ?>" target="_blank" class="small"><?php echo e('@' . config('variables.creatorName')); ?></a>
                </div>
                <div class="col-5 text-end mt-sm-0 mt-2">
                  <button class="btn btn-icon btn-label-danger"><i class="icon-base icon-22px ti tabler-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/instagram.png')); ?>" alt="instagram" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 row">
                <div class="col-7">
                  <h6 class="mb-0">instagram</h6>
                  <a href="<?php echo e(config('variables.instagramUrl')); ?>" target="_blank" class="small"><?php echo e('@' . config('variables.creatorName')); ?></a>
                </div>
                <div class="col-5 text-end mt-sm-0 mt-2">
                  <button class="btn btn-icon btn-label-danger"><i class="icon-base icon-22px ti tabler-trash"></i></button>
                </div>
              </div>
            </div>
            <div class="d-flex mb-4 align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/dribbble.png')); ?>" alt="dribbble" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 row">
                <div class="col-7">
                  <h6 class="mb-0">Dribbble</h6>
                  <small>Not Connected</small>
                </div>
                <div class="col-5 text-end mt-sm-0 mt-2">
                  <button class="btn btn-icon btn-label-secondary"><i class="icon-base icon-22px ti tabler-link"></i></button>
                </div>
              </div>
            </div>
            <div class="d-flex align-items-center">
              <div class="flex-shrink-0">
                <img src="<?php echo e(asset('assets/img/icons/brands/behance.png')); ?>" alt="behance" class="me-4" height="32" />
              </div>
              <div class="flex-grow-1 row  align-items-center">
                <div class="col-7">
                  <h6 class="mb-0">Behance</h6>
                  <small>Not Connected</small>
                </div>
                <div class="col-5 text-end">
                  <button class="btn btn-icon btn-label-secondary"><i class="icon-base icon-22px ti tabler-link"></i></button>
                </div>
              </div>
            </div>
            <!-- /Social Accounts -->
          </div>
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts/layoutMaster', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home1/dev61at/vuexytemp.dev61at.securebrandtech.com/resources/views/content/pages/pages-account-settings-connections.blade.php ENDPATH**/ ?>